﻿var schemes = {
    context: $("#themeEditor"),
    schemeId: 0,
    loadedSchemeId: 0,
    canModify: true,
    initialize: function () {
        schemes.initializeAutoComplete();
        schemes.toggleActionButtons();
    },
    bindEvents: function () {
        schemes.context.on("click", ".h-loadScheme", function () {
            schemes.getScheme();
        });

        schemes.context.on("click", ".h-saveScheme", function () {
            var autocompleteData = $(".h-schemeName-autocomplete", this.context).a4autocomplete("getData");
            var schemeName = schemes.getSchemeName();

            if (schemeName != "") {
                var filter = _.find(autocompleteData, function (d) { return d.Name == schemeName; });

                if (filter)
                    modalDialog.showConfirmDialog(confirmOverwriteSchemeResources, function () { schemes.saveScheme(schemeName); }, 220, 500, false, { "name": schemeName });
                else
                    schemes.saveScheme(schemeName);
            }
        });

        schemes.context.on("click", ".h-deleteScheme", function () {
            if (schemes.schemeId > 0) {
                var params = {
                    schemeId: schemes.schemeId,
                    name: schemes.getSchemeName()
                };

                modalDialog.showConfirmDialog(confirmDeleteSchemeResources, function () {
                    a4.callServerMethod(a4.getAction("DeleteScheme", "Modules", "Project"), params,
                    function (result) {
                        schemes.clearCache();
                        schemes.clearScheme(false);
                        schemes.toggleActionButtons();

                        if (result.message)
                            a4.showSuccessMessage(result.message, 2500)
                    });
                }, 250, 500, true, { "name": params.name });
            }
        });

        schemes.context.on("click", ".h-exportScheme", function () {
            schemes.exportScheme();
        });

        schemes.context.on("click", ".h-importScheme", function () {
            modalDialog.showWindow(a4.getAction("ImportScheme", "Modules", "Project"), 320, 600, {
                afterClose: function () {
                    schemes.clearCache();
                }
            });
        });

        schemes.context.on("input propertychange paste", ".h-schemeName-autocomplete", function () {
            $(".h-saveScheme", schemes.context).toggle(schemes.getSchemeName() != "");
        });
    },
    getSchemeName: function () {
        return $(".h-schemeName-autocomplete", schemes.context).val().trim();
    },
    toggleActionButtons: function () {
        $(".h-loadScheme", schemes.context).toggle(schemes.schemeId > 0);
        $(".h-saveScheme", schemes.context).toggle(schemes.canModify && schemes.getSchemeName() != "");
        $(".h-deleteScheme", schemes.context).toggle(schemes.canModify && schemes.schemeId > 0);
        $(".h-exportScheme", schemes.context).toggle(schemes.schemeId > 0);
    },
    getScheme: function () {
        var moduleId = parseInt(themeEditor.moduleId, 10);
        var projectId = parseInt(themeEditor.projectId, 10);

        if (schemes.schemeId > 0 && moduleId > 0 && projectId > 0) {
            var params = {
                projectId: projectId,
                moduleId: moduleId,
                schemeId: schemes.schemeId
            };

            a4.callServerMethod(a4.getAction("GetAppearanceScheme", "Modules", "Project"), params,
            function (result) {
                if (result.scheme) {
                    $(".h-themeEditorContent", schemes.context)[0].innerHTML = result.scheme;
                    schemes.loadedSchemeId = schemes.schemeId;
                    themeEditor.templateId = schemes.schemeId;
                    themeEditor.reInitializeEditor();

                    a4.showSuccessMessage(themeEditor.resources.SchemeLoadingComplete, 2500);
                }
            }, null, { blockElement: schemes.context });
        }
    },
    saveScheme: function (schemeName) {
        var id = schemes.loadedSchemeId || 0;

        var params = {
            name: schemeName,
            schemeId: id,
            moduleId: id > 0 ? null : themeEditor.moduleId,
            projectId: themeEditor.projectId,
            themeValues: themeEditor.values,
            properties: themeEditor.settings,
            translatableTexts: themeEditor.translatables
        };

        if (_.size(params.properties) == 0)
            params.properties = null;

        if (_.size(params.themeValues) == 0)
            params.themeValues = null;

        if (_.size(params.translatableTexts) == 0)
            params.translatableTexts = null;

        a4.callServerMethod(a4.getAction("SaveScheme", "Modules", "Project"), params,
        function (result) {
            schemes.clearCache();
            $(".h-schemeName-autocomplete", schemes.context).val(schemeName);
            schemes.schemeId = result.schemeId;
            schemes.loadedSchemeId = schemes.schemeId;
            schemes.toggleActionButtons();

            a4.showSuccessMessage(themeEditor.resources.SavedChangeSuccess, 2500);
        });
    },
    exportScheme: function () {
        if (schemes.schemeId > 0) {
            var params = {
                schemeId: schemes.schemeId,
                name: schemes.getSchemeName()
            };

            a4.callServerMethod(a4.getAction("ExportScheme", "Modules", "Project"), params,
            function (result) {
                a4.hideBusyBox();
                window.location = a4.getAction("GetSchemeFile", "Modules", "Project", { filename: result });
            });
        }
    },
    initializeAutoComplete: function () {
        $(".h-schemeName-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetSchemesForAutoComplete", "Modules", "Project"),
            validateSelection: false,
            valueProperty: "Id",
            labelProperty: "Name",
            defaultValue: 0,
            defaultValueWhenInvalid: true,
            select: function (event, data) {
                if (typeof data.item != "undefined") {
                    schemes.schemeId = data.item.Id || 0;
                    schemes.canModify = typeof data.item.CanModify !== "undefined" ? data.item.CanModify : true;
                    schemes.toggleActionButtons();
                }
            }
        });

        $(".h-schemeName-autocomplete", schemes.context).val("");
    },
    clearCache: function () {
        $(".h-schemeName-autocomplete", this.context).a4autocomplete("clearCache");
        schemes.initializeAutoComplete();
    },
    clearScheme: function (resetLoadedSchemeId) {
        $(".h-schemeName-autocomplete", schemes.context).a4autocomplete("clearValue");
        schemes.schemeId = 0;
        schemes.canModify = true;
        schemes.toggleActionButtons();

        if (resetLoadedSchemeId)
            schemes.loadedSchemeId = 0;
    }
};

$(document).ready(function () {
    if (schemes.context.length > 0) {
        schemes.initialize();
        schemes.bindEvents();
    }
});